<?php

class BankController extends Controller
{
	public $layout = '//layouts/column2';
	public $defaultAction = 'index';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + ajaxSelectBank, ajaxMakeTransfer'
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow students only
				'actions' => array('ajaxSelectBank', 'ajaxMakeTransfer', 'ajaxMakeDonationTransfer', 'ajaxMakeVatTransfer'),
				'roles' => array('student')
			),
			array('deny', // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionAjaxSelectBank()
	{
		header('Content-type: text/json; charset=utf-8');
		$result = array();

		try
		{
			if (!Akcja::isAnyInteriorAllowed('intBank1r1', 'intBank2r1', 'intBank2r2',
				'intBank3r1', 'intBank3r2', 'intBank4r1', 'intBank4r2'))
					throw new Exception('Akcja zablokowana');

			$bankId = filter_input(INPUT_POST, 'bankId', FILTER_VALIDATE_INT);
			$companyId = Yii::app()->user->id_firmy;

			$company = Firma::model()->find(array(
				'condition' => '"t"."status" > 0 and "t"."id" = :companyId and "u"."id" = :userId',
				'join' => 'left join "Uzytkownik" "u" on "u"."idFirmy" = "t"."id"',
				'params' => array(
					':companyId' => $companyId,
					':userId' => Yii::app()->user->id
				)
			));
			if (empty($company))
				throw new Exception ('Nie można odnaleźć firmy.');

			if (!empty($company->idBanku))
				throw new Exception('Już wcześniej wybrałeś(aś) bank. Każda firma może posiadać tylko jedno konto bankowe.');

			$company->idBanku = $bankId;
			$company->save(false);
			Akcja::removeSpecificAction("zaleglyBank", Yii::app()->user->id);
		}
		catch(Exception $e)
		{
			$result['error'] = $e->getMessage();
		}

		echo json_encode($result);
		Yii::app()->end();
	}

	public function actionAjaxMakeTransfer()
	{
		header('Content-type: text/json');
		$result = array();

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			if (!Akcja::isInteriorAllowedAndLessonActive('internetBankowosc'))
				throw new Exception('Akcja jest zablokowana.');

			$idFirmy = Yii::app()->user->id_firmy;

			$firma = Firma::model()->findByPk($idFirmy);
			if (empty($firma))
				throw new Exception('Użytkownik nie posiada firmy');

			$data = filter_input(INPUT_POST, 'transfer', FILTER_SANITIZE_STRING, FILTER_REQUIRE_ARRAY);

			//na podstawie DO KOGO, oblicza się rodzaj oplaty itp.
			//jak do zus to za darmo

			// sprawdzamy czy sie nie powtarza w dniu dzisiejszym
			$repeatedTransfer = Oplaty::model()->find(array(
				'condition'=>'"tytul" = \':title\' AND "idFirmy" = :idfirmy AND "czas" >= trunc(SYSDATE)',
				'params'=>array(
					'title'=>$data['tytul'],
					'idfirmy'=>$idFirmy,
				)
			));

			if(isset($repeatedTransfer))
				throw new Exception('Transakcja została już wykonana.');

			$oplata = new Oplaty; //('insert');
			$oplata->attributes = $data;
			$cena =  abs(floatval(str_replace(',', '.', $data['wartosc'])));
			$oplata->wartosc = -$cena;
			$oplata->rodzajOplaty = Oplaty::TYPE_TASK_PAYMENT;
			$oplata->czas = new CDbExpression('SYSDATE'); //null;
			$oplata->id = null;
			$oplata->idFirmy = $idFirmy;

			if ($cena <= 0)
			{
				$oplata->addError('wartosc', 'Nieprawidłowa wartość');
				$result['formErrors'] = $oplata->errors;
				throw new Exception('Invalid form');
			}

			if ($cena > $firma->stanKonta)
			{
				$oplata->addError('wartosc', 'Brak środków na koncie');
				$result['formErrors'] = $oplata->errors;
				throw new Exception('Invalid form');
			}

			$firma->stanKonta -= $cena;
			$firma->save(false);

			$result['stanKonta'] = $firma->stanKonta;
			$result['stanKontaTxt'] = $firma->stanKontaFormatted;

			if (!$oplata->save())
			{
				$result['formErrors'] = $oplata->errors;
				throw new Exception('Invalid form');
			}

			$transaction->commit();

			$result['wartosc'] = -$cena; //data['wartosc']; //$oplata->wartosc;
		}
		catch (Exception $e)
		{
			$result['error'] = $e->getMessage();
			$transaction->rollback();
		}

		echo json_encode($result);
		Yii::app()->end();
	}

	public function actionAjaxMakeDonationTransfer()
	{
		header('Content-type: text/json');
		$result = array();

		$transaction = Yii::app()->db->beginTransaction();

		try
		{
			//sprawdzamy, czy dotacja została już przyznana
			$donationUserAction = AkcjaUzytkownika::model()->find(array(
				'condition'=>'"idAkcji" = 50 AND "idFirmy" = :idFirmy AND "dataWykonania" is not null',
				'params'=>array(':idFirmy'=>Yii::app()->user->id_firmy),
			));

			if($donationUserAction !== null)
				throw new Exception('Nie można przyznać dotacji firmie po raz drugi.');

			$companyModel = Firma::model()->with(array('bank'))->findByPk(Yii::app()->user->getState('id_firmy'));

                        $znalezionaDotacja = Oplaty::model()->find(array(
                                'condition'=>'"idFirmy" = :id_firmy AND "rodzajOplaty" = 12',
                                'params'=>array(':id_firmy'=>Yii::app()->user->getState('id_firmy'))
                        ));
                        if(isset($znalezionaDotacja))
                                throw new Exception('Nie można przyznać dotacji firmie po raz drugi.');

			if($companyModel->bank !== null)
			{
				$przelew = new Oplaty;
				$przelew->rodzajOplaty = Oplaty::TYPE_DONATION_TRANSFER;
				$przelew->idFirmy = $companyModel->id;
				$przelew->idKontrahenta = 169; //Dotacja jest przyznawana z Urzędu Pracy
				$przelew->tytul = 'Dotacja na rozpoczęcie działalności gospodarczej';
				$przelew->wartosc = 20000;
				$przelew->czas = new CDbExpression('SYSDATE');
				$przelew->save(false);

				$companyModel->stanKonta = (float)$companyModel->stanKonta + (float)$przelew->wartosc;

				$bankToKontrahent = array(
					1=>149, //Cyfra Bank
					2=>150, //Flower Bank
					3=>151, //M4 Bank
					4=>152, //Money Stream Bank
				);

				$przelew = new Oplaty;
				$przelew->rodzajOplaty = Oplaty::TYPE_BANK;
				$przelew->idFirmy = $companyModel->id;
				$przelew->idKontrahenta = $bankToKontrahent[$companyModel->idBanku]; //Bank wybrany przez użytkownika
				$przelew->tytul = 'Opłata za utworzenie konta w banku';
				$przelew->wartosc = -$companyModel->bank->oplataZalozenie;
				$przelew->czas = new CDbExpression('SYSDATE');
				$przelew->save(false);

				$companyModel->stanKonta = (float)$companyModel->stanKonta + (float)$przelew->wartosc;
			}

			$companyModel->save(false);
			$transaction->commit();

			$result['wartosc'] = 20000; //$przelew->wartosc;
			Akcja::removeSpecificAction("zaleglaDotacja", Yii::app()->user->id);
		}
		catch (Exception $e)
		{
			$result['error'] = $e->getMessage();
			$transaction->rollback();
		}

		echo json_encode($result);
		Yii::app()->end();
	}

	public function actionAjaxMakeVatTransfer()
	{
		header('Content-type: text/json');
		$result = array();

		$transaction = Yii::app()->db->beginTransaction();

		try
		{
			// sprawdzamy, czy przelew został już wykonany
			$VATTransfered = AkcjaUzytkownika::model()->find(array(
				'condition'=>'"idAkcji" = 52 AND "idFirmy" = :idFirmy AND "dataWykonania" is not null',
				'params'=>array(':idFirmy'=>Yii::app()->user->id_firmy),
			));

			if($VATTransfered !== null)
				throw new Exception('Już wcześniej zapłacono za rejestrację VAT.');

			$companyModel = Firma::model()->findByPk(Yii::app()->user->getState('id_firmy'));

			$przelew = new Oplaty;
			$przelew->rodzajOplaty = Oplaty::TYPE_US;
			$przelew->idFirmy = $companyModel->id;
			$przelew->idKontrahenta = 189; // Urząd skarbowy
			$przelew->tytul = 'Opłata za rejestrację płatnika VAT.';
			$przelew->wartosc = -170;
			$przelew->czas = new CDbExpression('SYSDATE');
			$przelew->save(false);

			$companyModel->stanKonta = (float)$companyModel->stanKonta + (float)$przelew->wartosc;

			$companyModel->save(false);
			$transaction->commit();

			$result['wartosc'] = $przelew->wartosc;
		}
		catch (Exception $e)
		{
			$result['error'] = $e->getMessage();
			$transaction->rollback();
		}

		echo json_encode($result);
		Yii::app()->end();
	}
}
